/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.config.BooleanConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnLoot;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.contexts.base.Priority;
import com.mlib.effects.ParticleHandler;
import com.mlib.effects.SoundHandler;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.math.AnyPos;
import com.mlib.mixininterfaces.IMixinProjectile;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;

public class TelekinesisEnchantment
extends CustomEnchantment {
    public TelekinesisEnchantment() {
        this.rarity(Enchantment.Rarity.UNCOMMON).category(Registries.TOOLS).slots(EquipmentSlots.MAINHAND).minLevelCost(level -> 15).maxLevelCost(level -> 45);
    }

    @AutoInstance
    public static class Handler {
        static final ParticleHandler PARTICLE = new ParticleHandler(Registries.TELEKINESIS_PARTICLE, ParticleHandler.offset((float)0.5f), ParticleHandler.speed((float)0.015f));
        final BooleanConfig particlesVisibility = new BooleanConfig(true);
        final Supplier<TelekinesisEnchantment> enchantment = Registries.TELEKINESIS;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("Telekinesis").comment("Adds acquired items directly to player's inventory.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnLoot.listen(data -> this.addToInventory((OnLoot.Data)data, data.entity)).priority(Priority.LOWEST).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> data.entity instanceof Player)).addCondition(Condition.predicate(data -> data.tool != null && this.enchantment.get().hasEnchantment(data.tool))).addCondition(OnLoot.hasOrigin()).addConfig((IConfigurable)this.particlesVisibility.name("spawn_particles").comment("Determines whether Telekinesis should spawn any particles.")).insertTo(group);
            OnLoot.listen(data -> this.addToInventory((OnLoot.Data)data, data.killer)).priority(Priority.LOWEST).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> data.killer instanceof Player)).addCondition(Condition.predicate(data -> this.enchantment.get().hasEnchantment((LivingEntity)((Player)data.killer)))).addCondition(OnLoot.hasOrigin()).insertTo(group);
            OnLoot.listen(data -> this.addToInventory((OnLoot.Data)data, data.killer)).priority(Priority.LOWEST).addCondition(Condition.isServer()).addCondition(OnLoot.hasOrigin()).addCondition(Condition.predicate(data -> data.killer instanceof Player)).addCondition(Condition.predicate(this::doesProjectileHasEnchantment)).insertTo(group);
        }

        private void addToInventory(OnLoot.Data data, Entity entity) {
            Player player = (Player)entity;
            assert (player != null && data.getLevel() != null);
            if (data.generatedLoot.removeIf(arg_0 -> ((Player)player).m_36356_(arg_0))) {
                SoundHandler.ITEM_PICKUP.play(data.getLevel(), player.m_20182_(), SoundHandler.randomized((float)0.25f));
                if (this.particlesVisibility.isEnabled()) {
                    this.spawnParticles(data, player);
                }
            }
        }

        private void spawnParticles(OnLoot.Data data, Player player) {
            Vec3 from = AnyPos.from((Vec3)data.origin).add((Number)0.0, (Number)(data.killer != null && data.entity != null ? (double)data.entity.m_20206_() * 0.75 : 0.0), (Number)0.0).vec3();
            Vec3 to = AnyPos.from((Vec3)player.m_20182_()).add((Number)0.0, (Number)((double)player.m_20206_() * 0.5), (Number)0.0).vec3();
            PARTICLE.spawnLine(data.getServerLevel(), from, to, 3);
        }

        private boolean doesProjectileHasEnchantment(OnLoot.Data data) {
            if (data.damageSource != null) {
                ItemStack weapon = IMixinProjectile.getWeaponFromDirectEntity((DamageSource)data.damageSource);
                return weapon != null && this.enchantment.get().hasEnchantment(weapon);
            }
            return false;
        }
    }
}

